package editor;

import game.CustomImageDataII;
import game.IntRect;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.ImageObserver;

public class GoalScreenPaletteObject extends ScreenPaletteObject {
	
	private RoomEditorPanel editorPanel;
	private CustomImageDataII [] cutscene;
	private boolean passThru;
	private boolean enableCommentary;
	
	
	public GoalScreenPaletteObject(IntRect theClickRect, int theDistanceToBorder, int theBorderWidth, ImageObserver io, RoomEditorPanel theEditorPanel) {
		
		clickRect = theClickRect;
		
		image = new CustomImageDataII("/images/goal.GIF", Color.green, io);
		
		distanceToBorder = theDistanceToBorder;
		borderWidth = theBorderWidth;
		editorPanel = theEditorPanel;
	}
	
	
	@Override
	public ScreenObject create(int objX, int objY, ImageObserver io) {
		if(editorPanel.doesGoalAlreadyExist())
			return null;
		return new GoalScreenObject(objX, objY, io, this, passThru, enableCommentary);
	}

	@Override
	public void draw(Graphics g) {
		
		if(clickRect == null)
			return;
		
		Point p = clickRect.getCenter();
		
		image.drawObjectIgnoreBounds(g, p.x, p.y);
		
		Color origCol = g.getColor();
		
		if(isSelected) {
			g.setColor(new Color(255, 200, 0));
		} else {
			g.setColor(new Color(100, 100, 100));
		}
		
		for(int i = 0; i < borderWidth; i++) {
			g.drawRect(clickRect.getMinX() - (distanceToBorder + i), clickRect.getMinY() - (distanceToBorder + i), clickRect.width() + (distanceToBorder + i) * 2, clickRect.height() + (distanceToBorder + i) * 2);
		}
		
		
		g.setColor(origCol);
		
	}


	@Override
	public void delete(ScreenObject so) {
		// TODO Auto-generated method stub
		
	}


	public CustomImageDataII[] getCutscene() {
		return cutscene;
	}


	public void setCutscene(CustomImageDataII[] cutscene) {
		this.cutscene = cutscene;
		
//		for(CustomImageDataII cid : cutscene) {
//			System.out.println("now checking to see if the cutscene has a null filename; it really, really shouldn't.  " + cid.getFileName());
//		}
		
	}


	public boolean isPassThru() {
		return passThru;
	}


	public void setPassThru(boolean passThru) {
		this.passThru = passThru;
	}


	public boolean isEnableCommentary() {
		return enableCommentary;
	}


	public void setEnableCommentary(boolean enableCommentary) {
		this.enableCommentary = enableCommentary;
	}
	
	
	
	

}
